terraform {
  required_version = ">= 1.0.0, < 2.0.0"

  required_providers {
    aws = {
      source  = "hashicorp/aws"
      version = "~> 4.0"
    }
    kubernetes = {
      source  = "hashicorp/kubernetes"
      version = "~> 2.0"
    }
  }
}

provider "aws" {
  region = "us-east-2"
}

# Konieczne jest uwierzytelnienie klastra EKS, ale dopiero po jego utworzeniu.
# W tym celu można wykorzystać źródło danych aws_eks_cluster_auth i tym samym
# mieć zależność od niego w danych wyjściowych modułu eks-cluster.

provider "kubernetes" {
  host = module.eks_cluster.cluster_endpoint
  cluster_ca_certificate = base64decode(
    module.eks_cluster.cluster_certificate_authority[0].data
  )
  token = data.aws_eks_cluster_auth.cluster.token
}

data "aws_eks_cluster_auth" "cluster" {
  name = module.eks_cluster.cluster_name
}

# Utworzenie klastra EKS.

module "eks_cluster" {
  source = "../../modules/services/eks-cluster"

  name = var.cluster_name

  min_size     = 1
  max_size     = 2
  desired_size = 1

  # Ze względu na sposób działania EKS z ENI, t3.small to najmniejszy
  # typ egzemplarza, który może być użyty dla węzła roboczego. Jeżeli
  # spróbujesz użyć mniejszego, np. t2.micro, który ma tylko 4 ENI, to
  # wszystkie zostaną użyte przez usługi systemowe (np. kube-proxy)
  # i nie będzie możliwości wdrożenia własnych podów.
  instance_types = ["t3.small"]
}

# Wdrożenie prostej aplikacji internetowej w klastrze EKS.

module "simple_webapp" {
  source = "../../modules/services/k8s-app"

  name = var.app_name

  image          = "training/webapp"
  replicas       = 2
  container_port = 5000

  environment_variables = {
    PROVIDER = "Terraform"
  }

  # Wdrożenie może się odbywać tylko po wdrożeniu klastra.
  depends_on = [module.eks_cluster]
}
